#!/usr/bin/env python3

import sys, re, os, os.path, tempfile

with tempfile.NamedTemporaryFile() as tmp:
    fname=tmp.name

    src_fname=sys.argv[1]
    src_base_fname=os.path.basename(src_fname)
    os.system (f"cflow {src_fname} > {fname}")

    stack={}

    with open(fname, "rt") as f:
        for l in f:
            l=l.rstrip()
            t=re.match ("^( *)([a-zA-Z0-9_]+)().*", l)
            level=len(t[1])//4
            func_name=t[2]
            #print (level, func_name)
            stack[level]=func_name
            if level>=1:
                print (stack[level-1], stack[level])
                #print (src_base_fname+"!"+stack[level-1], src_base_fname+"!"+stack[level])

